
from flask import Flask

app = Flask(__name__)

@app.route('/')
def index():
    return '''
    <!DOCTYPE html>
    <html>
    <head>
        <title>Micro Server 7</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 40px; }
            h1 { color: #333; }
        </style>
    </head>
    <body>
        <h1>Micro Server 7 Running</h1>
        <p>This is a customizable micro server running on port 5007.</p>
        <p>Edit your server code in the control panel.</p>
        <p><a href="http://localhost:5000/servers">Back to Control Panel</a></p>
    </body>
    </html>
    '''

@app.route('/hello')
def hello():
    return "Hello from Server 7!"

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5007, debug=False)
